package ppbot;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.AutoTraceRay;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.exceptions.PogamutException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/**
 * This class may serve as an example how to create a raycasting bot
 * that defines a several rays.
 * 
 * Currently there are some problem with the platform and the coding is not
 * as clear as we would like...
 */
public class GeneticMain extends Agent {

    NeuralNetwork net;
    GeneticAlgorithm gA;
    final double alpha = 0.25;
    
    File popfile = new File("popfile");
    File fitfile = new File("./fitfile.txt");
    File lastSerializedPop = new File("lastSerializedPop.out");
    File bestNetFile;
    FileWriter popwriter;
    FileWriter fitwriter;
    private int roundsNotMoving;
    /** Creates a new instance of agent. */
    public GeneticMain() {
    }
    
    /**
     * First we will create an enum that will contain all the rays we are
     * going to use.
     * 
     * Every ray is described as triple:
     *      ID ... number under which it will be returned from GB
     *      Vector ... where the vector is going from the bot as 0,0,0
     *             ... 1, 0, 0 go straight ahead from the bot
     *             ... 0, 1, 0 go to the left from the bot
     *             ... 0,-1, 0 go to the right from the bot
     *             ... note that the vector serves only as direction, length is not taken into account
     *      Length ... how far we're tracing
     */
    public enum Ray {
        
        /**
         * Ray that is going straight ahead before the bot and is 200 long.
         */
        STRAIGHT_AHEAD_300(1, new Triple(1, 0, 0), 300),
        
        STRAIGHT_AHEAD_200(3, new Triple(1, 0, 0), 200),
        /**
         * Ray that goes 45 degrees to the left of the bot.
         */
        LEFT45_200(2, new Triple(1, 1.25, 0), 225),
        

  //      STRAIGHT_UP_200(5, new Triple(1, 0, 0.25), 200),

  //      STRAIGHT_DOWN_200(6, new Triple(1, 0, -0.25), 200),
        /**
         * Ray that goes to the left of the bot.
         */
        //LEFT90_200(3, new Triple(0, 1, 0), 200),
        
        /**
         * Ray that goes 45 degrees to the right of the bot.
         */
        RIGHT45_200(4, new Triple(1, -1.25, 0), 225)
        
        /**
         * Ray that goes to the right of the bot.
         */
        /*RIGHT90_200(5, new Triple(0, -1, 0), 200)*/;
        
        private int id;
        private Triple vector;
        private double length;
        
        private Ray(int id, Triple vector, double length) {
            this.id = id;
            this.vector = vector;
            this.length = length;
        }
        
        public int getId() {
            return id;
        }
        
        public Triple getVector() {
            return vector;
        }
        
        public double getLength() {
            return length;
        }
        
    }
    
    /**
     * Next we will declare an inner class that will take care of the traces.
     * It will listen on the ATR messages and write them to it's map (therefore
     * it implements RcvMsgListener).
     */
    private class RayTraces implements RcvMsgListener {
        
        /**
         * Here we will store the last results of raycastings.
         * 
         *  Ray's ID -> result
         * (Integer  -> AutoTraceRay)
         */
        private Map<Integer, AutoTraceRay> traces = new HashMap<Integer, AutoTraceRay>();
        
        public RayTraces() {            
        }
        
        /**
         * This method will be called from doLogic() only once to initialize the object.
         */
        public void botInit() {
            log.info("RayTraces.botInit(): called");
            
            // tells the GameBots we want autotracing
            body.startAutoTrace();
            
            // remove default auto trace rays
            body.removeAllRaysFromAutoTrace();
            
            // now 1) register every ray inside GameBots and
            //     2) create initial value for every ray
            for (Ray ray : Ray.values()) {
                body.addRayToAutoTrace(ray.getId(), ray.getVector(), ray.getLength(), 
                                       false, // whether this is FastTrace ... NO we want full trace
                                              // to get HitNormal informations
                                       false  // whether we should trace the players and helaths as well
                                              // NO ... we want only walls, floors, etc.
                                      );
                traces.put(ray.getId(), new AutoTraceRay());
            }
            
            // register itself as a listener for ATR messages, so 
            // we can catch the AUTO_TRACE_RAY
            body.addTypedRcvMsgListener(this, MessageType.AUTO_TRACE_RAY);
            
            // now a little workarounds ...
            
            // we have to move a bot a bit to get first readings from rays
            body.moveInch();
            
            // now, to see only new rays (not the default ones), we have to switch
            // visibility of autotraces off and on again (with little delay)
            body.configureAutoTrace(false);
            try {
                Thread.sleep(200);
            } catch (InterruptedException ex) {               
            }
            body.configureAutoTrace(true);

        }

        /**
         * In this method we're receiving notices about ATR messages. It's
         * called every time when ATR message arrives.
         * @param e
         */
        @Override
        public void receiveMessage(RcvMsgEvent e) {
            // get the message from the event (casting it properly)
            AutoTraceRay ray = (AutoTraceRay)e.getMessage();
            try {
                // be synchronized with 'traces' to prevent concurrent read/write operations
                synchronized(traces) {
                    // insert the ray under it's number
                    // notice that ID goes under UnrealID field in the 'ray'
                    traces.put(Integer.parseInt(ray.UnrealID), ray);
                }
            } catch (Exception ex) {
                log.severe(ex.getMessage());
            }
        }
        
        
        /**
         * Returns info about one ray.
         * @param ray
         * @return
         */
        public AutoTraceRay getTrace(Ray ray) {
            synchronized(traces) {
                return traces.get(ray.getId());
            }            
        }
        
        /**
         * Returns the copy of the map of traces.
         * 
         * This will be useful for you when you will program the
         * control mechanism of the bot. You shouldn't rely on the getTrace()
         * because two calls of it may return different result (because of 
         * a two thread design of the bot).
         * 
         * @return current state of traces
         */
        public Map<Integer, AutoTraceRay> getTraceSnapshot() {
            synchronized(traces) {
                return new HashMap<Integer, AutoTraceRay>(traces);
            }
        }
        
    }
    
    /**
     * create an instance of our RayTracing manager
     */
    private RayTraces traces = new RayTraces();
    
    /**
     * Flag that tells us whether we should initialize things in doLogic().
     */
    private boolean init = true;
    
    /**
     * This is initiliazation method for the bot, it's called only once from doLogic()
     */    
    private void init() {        
        // we're initializing the traces here
        traces.botInit();
    }
    
    /**
     * Main method of the agent that is called iteratively from logic thread.
     */
    
    int iteration = 0;
    int itcount = 40;
    int generation = 0;
    Set<String> visitedNavPoints = new HashSet<String>();
    int freeCounter;
    int botCount;
    double newFitness;
    double randomInput = 1;
    
    private class VectorAlgebra {
        public double computeInnerAngle(Triple u, Triple v)
        {
            u.z = 0;
            v.z = 0;
            normalize(u);
            normalize(v);
            return Math.acos((u.x * v.x + u.y * v.y) / (Math.sqrt(u.x * u.x + u.y * u.y) * Math.sqrt(v.x * v.x + v.y * v.y)));
        }
        
        public Triple getTripleFromAngle(double angle)
        {
            return new Triple(Math.cos(angle),Math.sin(angle),0);
        }
        
        public boolean compareTriples(Triple u, Triple v)
        {
            return (Math.abs(u.x - v.x) + Math.abs(u.y - v.y) + Math.abs(u.z - v.z)) < 1e-5;
        }
        
        public Triple addTriples(Triple u, Triple v)
        {
            return new Triple(u.x+v.x, u.y+v.y, u.z+v.z);
        }
        
        public double computeCycleAngle(Triple u)
        {
            u.z = 0;
            normalize(u);
            return u.y >= 0 ? Math.acos(u.x) : 2*Math.PI - Math.acos(u.x);
        }
        public void normalize(Triple u)
        {
            double size = u.x * u.x + u.y * u.y + u.z * u.z;
            size = Math.sqrt(size);
            if (size > 0) {
                u.x/=size; u.y/=size; u.z/=size; 
            }
        }
    }
    
    private VectorAlgebra vectorAlgebra = new VectorAlgebra();
    
    public double getInputAngle(Triple from, Triple to, Triple normal)
    {
        Triple ray = new Triple(to.x - from.x, to.y - from.y, 0);
        vectorAlgebra.normalize(ray);
        log.info("RAY:"+ray.x+","+ray.y+","+ray.z);

        normal.z = 0;
        vectorAlgebra.normalize(normal);
        
        log.info("NORMAL:"+normal);
        
        Triple sum = vectorAlgebra.addTriples(ray, normal);
        vectorAlgebra.normalize(sum);

        log.info("SUM:"+sum);

        double rayAngle = vectorAlgebra.computeCycleAngle(ray);
        double sumAngle = vectorAlgebra.computeCycleAngle(sum);
        double innerAngle = vectorAlgebra.computeInnerAngle(ray, sum);
        
        double angle = vectorAlgebra.compareTriples(sum, 
                vectorAlgebra.getTripleFromAngle(rayAngle + innerAngle)) ? 
                    innerAngle : - innerAngle;
        
        log.info("ANGLE:"+angle);
        return angle;
    }
    
    private class LongTimeMemory extends LinkedList<Double>
    {
        public LongTimeMemory(int horizont) 
        {            
            for(int i=0; i<horizont; i++)
                add(new Double(0));
        }
    }
    
    LongTimeMemory longTimeMemory = null;
    
    private DeadListener deadListener = new DeadListener();
    
    private class DeadListener implements RcvMsgListener {

        public DeadListener() 
        {
            body.addTypedRcvMsgListener(this, MessageType.BOT_KILLED);            
        }

        public void receiveMessage(RcvMsgEvent e) {
            net.geneticFitness = alpha * newFitness / 5 + (1 - alpha) * net.geneticFitness;
            iteration = 0;
            freeCounter = 0;
            body.sendGlobalMessage("DIEEEEEEED!!!");
        }
    }   
    
    protected void doLogic() {
        if (init) {
            init(); 
            init = false; 
        }

        
        if (iteration++ == 0)
        {
            net = (NeuralNetwork)gA.getNext();
            roundsNotMoving = 0;
            visitedNavPoints.clear();
            botCount++;
            newFitness = 0;
            longTimeMemory = new LongTimeMemory(3);
            if (net == null)
            {
                botCount = 0;
                gA.step();
                net = (NeuralNetwork) gA.getNext();
                net.setInput(4, 0);
                net.setInput(5, 0);
                generation++;
                itcount += 2;
                try {
                       popwriter.write("Population " + generation + "\n");
                       popwriter.write(gA.populationToString()+"\n\n");
                       body.sendGlobalMessage("GENERATION: "+ generation);
                       
                       fitwriter.write(gA.getPopulationBestFitness()+" "+gA.getPopulationAverageFitness()+"\n");
                       fitwriter.flush();

                       bestNetFile = new File("bestNet"+generation+".out");
                       bestNetFile.createNewFile();
                       ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(bestNetFile));
                       gA.getBestIndividual().serialize(oos);
                       oos.close();
                       
                       oos = new ObjectOutputStream(new FileOutputStream(lastSerializedPop));
                       gA.serializePopulation(oos);
                       oos.close();
                       
                       ObjectInputStream ois = new ObjectInputStream(new FileInputStream(lastSerializedPop));
                       gA.deserializePopulation(ois);
                       
                } catch (Exception ex) { System.err.println(ex.getMessage()); }
                
            }
        }
        
        System.out.println("NH:"+net.hashCode());
        
        //body.sendGlobalMessage("RESTART");
        
        //if (net == null) 
        
        
        int size = visitedNavPoints.size();
        visitedNavPoints.add(getMap().nearestNavPoint(memory.getAgentLocation()).UnrealID);
        if (visitedNavPoints.size() > size) {
            iteration-=30;
            newFitness+= 1 + freeCounter / 20.0;
        }
        if (iteration <= 0) iteration = 1;
        
        
        //memory.s
        //body.sendGlobalMessage("NEAREST: " + getMap().nearestNavPoint(memory.getAgentLocation()).UnrealID);
        
        
        // mark the beginning of the new logic iteration
        log.warning("LOGIC ITERATION");

        // get current snapshot of rays
        Map<Integer, AutoTraceRay> rays = traces.getTraceSnapshot();
        for (AutoTraceRay ray : rays.values()) {
            // log them
            log.info(ray.toString());
        }
        
        // now you may write code like this...
        // obviously this is pretty stupid thing to do,
        // but it's example ;-)
        
        
        //log.warning("NORMAL"+rays.get(Ray.STRAIGHT_AHEAD_300.getId()).hitNormal.toString());
                
        if (rays.get(Ray.LEFT45_200.getId()).result)
            net.setInput(0, 1);
        else 
            net.setInput(0, -1);

        if (rays.get(Ray.RIGHT45_200.getId()).result)
            net.setInput(1, 1);
        else 
            net.setInput(1, -1);        
        
        if (rays.get(Ray.STRAIGHT_AHEAD_300.getId()).result)
            net.setInput(2, 1);
        else 
            net.setInput(2, -1);
        
        /*if (rays.get(Ray.STRAIGHT_AHEAD_300.getId()).hitNormal != null)
            body.sendGlobalMessage("NORMAL: "+rays.get(Ray.STRAIGHT_AHEAD_300.getId()).hitNormal.toString());
        */
        /*if (rays.get(Ray.STRAIGHT_UP_200.getId()).result)
            net.setInput(4, 1);
        else 
            net.setInput(4, 0);

        if (rays.get(Ray.STRAIGHT_DOWN_200.getId()).result)
            net.setInput(5, 1);
        else 
            net.setInput(5, 0);
*/
        if (!rays.get(Ray.STRAIGHT_AHEAD_200.getId()).result)
            freeCounter++;
        
        if (!memory.getAgentIsMoving()) 
            roundsNotMoving++; else roundsNotMoving = 0;

        net.setInput(3, roundsNotMoving > 3 ? 1 : -1);                
        
        net.setInput(4, 2 * net.getOutput(3) - 1);
        net.setInput(5, longTimeMemory.pop());

        log.info("LongTimeMemory="+longTimeMemory.toString());
        
        /*try {
            Triple from = (Triple) rays.get(Ray.STRAIGHT_AHEAD_300.getId()).from.clone();
            Triple to = (Triple) rays.get(Ray.STRAIGHT_AHEAD_300.getId()).to.clone();
            Triple hit = (Triple) rays.get(Ray.STRAIGHT_AHEAD_300.getId()).hitNormal.clone();
            double angle = getInputAngle(from, to, hit);
            body.sendGlobalMessage("ANGLE:"+angle);     
            if (Math.abs(angle) > 2) angle = 0;
            net.setInput(4, angle);
        } catch (NullPointerException ex) {
            net.setInput(4, 0);
        }*/
        
        //if (Math.random() > 0.8) Math.random();
        
        //net.setInput(4, Math.random() > 0.5 ? 1 : 0);                

        net.compute();
        
        longTimeMemory.add(2 * net.getOutput(4) - 1);
        
        double angle = (net.getOutput(0) - net.getOutput(1));
        
        if (Math.abs(angle) > 0.08) {//Math.max(0.08/*, 0.12 - (itcount/100.0))*/ ) {
            body.turnHorizontal((int)(60*angle));
            freeCounter++;
        } else
        //if (net.getOutput(3) > 0.5)
          //  body.jump();// else
        body.contMove((float)net.getOutput(2) );
        
        
        
        
        /*int winner = 0 ; double maxvalue = 0;
        for(int i=0; i<net.outputCount; i++)
            if (net.getOutput(i) > maxvalue)
            {
                maxvalue = net.getOutput(i);
                winner = i;
            }
            
        switch (winner)
        {
            case 0 : body.contMove((float)net.getOutput(0));
            break;
            case 1 : body.turnHorizontal((int)(45 * net.getOutput(1)));
        }*/
        
/*        if (net.getOutput(1) > 0.1)
        body.turnHorizontal((int)(45 * net.getOutput(1)));
        else
        body.contMove((float)net.getOutput(0));
*/
        //body.sendGlobalMessage("Out:["+net.getOutput(0)+","+net.getOutput(1)+"]");
    
        body.sendGlobalMessage( "["+generation+","+botCount+"] IT:"+iteration+(net.isElite() ? " *" : "")+" Fitness = "+newFitness);
        
        if ((iteration >= itcount) || (roundsNotMoving > 25))
        {
            iteration = 0;
            net.geneticFitness = alpha * newFitness + (1 - alpha) * net.geneticFitness;
            freeCounter = 0;
            body.respawn();            
        }
        
            // if the ray that is going STRAIGHT_AHEAD returns true ... turn to the right
//            body.turnHorizontal(90);
  //          return;
     /*   } /*else 
        if (rays.get(Ray.LEFT90_200.getId()).result) {    
            body.turnHorizontal(15);
            return;
        } else 
        if (rays.get(Ray.LEFT45_200.getId()).result) {    
            body.turnHorizontal(45);
            return;
        } else 
        if (rays.get(Ray.RIGHT90_200.getId()).result) {    
            body.turnHorizontal(-15);
            return;
        } else 
        if (rays.get(Ray.RIGHT45_200.getId()).result) {    
            body.turnHorizontal(-45);
            return;
        }*/
        
        // if no turning takes place ... move forward continuously 
       //body.contMove((float)0.7);
    }
  
    protected void prePrepareAgent() throws PogamutException {
            int[] layers = {6,12,5};
            net = new NeuralNetwork(layers);
            net.mutStrength = 0.75;

            gA = new GeneticAlgorithm(12, net);
            gA.mutRate = 0.15;
            gA.crossRate = 0.25;
            
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(lastSerializedPop));
                gA.deserializePopulation(ois);            
            } catch (Exception ex) {
                System.err.println("Error:"+ex.getMessage());
                //return;
                gA.initializePopulationRandomly();
            }
            
            try {
                popfile.createNewFile();
                fitfile.createNewFile();
                System.out.println(popfile.getAbsolutePath());
                popwriter = new FileWriter(popfile);
                popwriter.write("Population 0:\n");
                popwriter.write(gA.populationToString()+"\n\n");
                popwriter.flush();
                fitwriter = new FileWriter(fitfile);
            } catch (IOException ex) {
                popwriter = null;
            }
            
            
            System.out.println("Initialization done");

            /*        net.neurons.get(1).weights[0] = -10;
            net.neurons.get(1).setBias(1);
            net.neurons.get(2).weights[0] = 11;
            net.neurons.get(2).setBias(-10); */

        /*        net.neurons.get(1).weights[0] = -10;
        net.neurons.get(1).setBias(1);
        net.neurons.get(2).weights[0] = 11;
        net.neurons.get(2).setBias(-10); */
    }

    @Override
    protected void postPrepareAgent() throws PogamutException {
        try {
            popwriter.flush();
            fitwriter.flush();
        } catch (IOException ex) {  }
        
    }

    protected void shutdownAgent() throws PogamutException {
    // Clean up after the end of simulation of agent
        try {
            popwriter.close();
            fitwriter.close();
        } catch (IOException ex) {  }
 
    }

    public static void main(String[] args) {
    /*
    DON'T DELETE THIS METHOD, IF YOU DELETE IT NETBEANS WON'T LET YOU RUN THIS 
    BOT. HOWEVER THIS METHOD IS NEVER EXECUTED, THE BOT IS LAUNCHED INSIDE THE 
    NETBEANS BY A CUSTOM ANT TASK (see build.xml).
     */
    }
}
